<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Big Impresa
 */

get_header(); ?>

    <div id="primary" class="content-area">
        <main id="main" class="site-main focus" role="main">

        <?php
        while ( have_posts() ) : the_post();

            get_template_part( 'template-parts/content', get_post_format() );

            if (get_theme_mod('post_nav', true)) {
                the_post_navigation( array(
                'next_text' => __( 'Next', 'big-impresa' ),
                'prev_text' => __( 'Previous', 'big-impresa' ),
                ) );
            }

            // If comments are open or we have at least one comment, load up the comment template.
            if ( comments_open() || get_comments_number() ) :
                comments_template();
            endif;

        endwhile; // End of the loop.
        ?>

        </main><!-- #main -->
    </div><!-- #primary -->

<?php
get_sidebar();
get_footer();
